%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Virtual model Mathematics building departament 
% Coordinate change

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load("dataMathematics.mat");

% Traslacin
xM = 28.2239;
yM = 57.5644;

% Rotation
xM1 = 5.68;
yM1 = 54.18; 
xM2 = 27.41;
yM2 = 65.16; 

xvM = xM2 - xM1;
yvM = yM2 - yM1;

vM = sqrt(xvM^2 + yvM^2);

xG1 = 0;
yG1 = 0;
xG2 = 14.54;
yG2 = -0.0394;

xvG = xG2 - xG1;
yvG = yG2 - yG1;

vG = sqrt(xvG^2 + yvG^2);

s = (xvG*xvM+yvG*yvM)/(vG*vM);
s = 0.922;
angle = -acos(s);


for i=1:1:size(dataMathematics.wall,2)
    
    %% Traslacin
    
    % x
    dataMathematics.wall(i).p1(1) =  dataMathematics.wall(i).p1(1) + xM;
    dataMathematics.wall(i).p2(1) =  dataMathematics.wall(i).p2(1) + xM;
    dataMathematics.wall(i).p3(1) =  dataMathematics.wall(i).p3(1) + xM;
    dataMathematics.wall(i).p4(1) =  dataMathematics.wall(i).p4(1) + xM;
   
    % y
    dataMathematics.wall(i).p1(2) =  dataMathematics.wall(i).p1(2) + yM;
    dataMathematics.wall(i).p2(2) =  dataMathematics.wall(i).p2(2) + yM;
    dataMathematics.wall(i).p3(2) =  dataMathematics.wall(i).p3(2) + yM;
    dataMathematics.wall(i).p4(2) =  dataMathematics.wall(i).p4(2) + yM;

    
    % Rotation
    % x
    dataMathematics.wall(i).p1(1) =  dataMathematics.wall(i).p1(1)*cos(angle) + dataMathematics.wall(i).p1(2)*sin(angle);
    dataMathematics.wall(i).p2(1) =  dataMathematics.wall(i).p2(1)*cos(angle) + dataMathematics.wall(i).p2(2)*sin(angle);
    dataMathematics.wall(i).p3(1) =  dataMathematics.wall(i).p3(1)*cos(angle) + dataMathematics.wall(i).p3(2)*sin(angle);
    dataMathematics.wall(i).p4(1) =  dataMathematics.wall(i).p4(1)*cos(angle) + dataMathematics.wall(i).p4(2)*sin(angle);
    
    
    % y
    dataMathematics.wall(i).p1(2) =  -dataMathematics.wall(i).p1(1)*sin(angle) + dataMathematics.wall(i).p1(2)*cos(angle);
    dataMathematics.wall(i).p2(2) =  -dataMathematics.wall(i).p2(1)*sin(angle) + dataMathematics.wall(i).p2(2)*cos(angle);
    dataMathematics.wall(i).p3(2) =  -dataMathematics.wall(i).p3(1)*sin(angle) + dataMathematics.wall(i).p3(2)*cos(angle);
    dataMathematics.wall(i).p4(2) =  -dataMathematics.wall(i).p4(1)*sin(angle) + dataMathematics.wall(i).p4(2)*cos(angle);
    
end

for i=1:1:size(dataMathematics.pE1,1)
    
    %% Traslacin  
    % x
    dataMathematics.pE1(i,1) = dataMathematics.pE1(i,1) + xM;
    
    % y
    dataMathematics.pE1(i,2) = dataMathematics.pE1(i,2) + yM;
    
    % Rotation
    % x  
    dataMathematics.pE1(i,1) = dataMathematics.pE1(i,1)*cos(angle) + dataMathematics.pE1(i,2)*sin(angle);
    
    % y
    dataMathematics.pE1(i,2) = -dataMathematics.pE1(i,1)*sin(angle) + dataMathematics.pE1(i,2)*cos(angle);
end

save('dataMathematics','dataMathematics');   